% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HeckmantS.R
\name{HeckmantS}
\alias{HeckmantS}
\title{Heckman-t Model Fit Function}
\usage{
HeckmantS(selection, outcome, data = sys.frame(sys.parent()), df, start = NULL)
}
\arguments{
\item{selection}{A formula specifying the selection equation.}

\item{outcome}{A formula specifying the outcome equation.}

\item{data}{A data frame containing the variables in the model.}

\item{df}{Initial value for the degrees of freedom parameter of the t-distribution.}

\item{start}{Optional numeric vector of initial parameter values.}
}
\value{
A list containing:
\itemize{
  \item \code{coefficients}: Named vector of estimated model parameters.
  \item \code{value}: Negative of the maximum log-likelihood.
  \item \code{loglik}: Maximum log-likelihood.
  \item \code{counts}: Number of gradient evaluations performed.
  \item \code{hessian}: Hessian matrix at the optimum.
  \item \code{fisher_infotS}: Approximate Fisher information matrix.
  \item \code{prop_sigmatS}: Standard errors for the parameter estimates.
  \item \code{level}: Levels of the selection variable.
  \item \code{nObs}: Number of observations.
  \item \code{nParam}: Number of model parameters.
  \item \code{N0}: Number of censored (unobserved) observations.
  \item \code{N1}: Number of uncensored (observed) observations.
  \item \code{NXS}: Number of parameters in the selection equation.
  \item \code{NXO}: Number of parameters in the outcome equation.
  \item \code{df}: Degrees of freedom (observations minus parameters).
  \item \code{aic}: Akaike Information Criterion.
  \item \code{bic}: Bayesian Information Criterion.
  \item \code{initial.value}: Initial parameter values used in the optimization.
}
}
\description{
Fits a sample selection model based on the Student's t-distribution,
extending the classical Heckman model to account for heavy-tailed error terms.
The estimation is performed via Maximum Likelihood using the BFGS algorithm.
}
\details{
The function implements the Heckman sample selection model using
the Student's t-distribution for the error terms, as proposed by
\insertCite{marchenko2012heckman;textual}{ssmodels}. This extension
allows for robustness against outliers and heavy-tailed distributions.
Initial parameter values can be specified by the user or default to standard starting values.
}
\examples{
data(MEPS2001)
attach(MEPS2001)
selectEq <- dambexp ~ age + female + educ + blhisp + totchr + ins + income
outcomeEq <- lnambx ~ age + female + educ + blhisp + totchr + ins
HeckmantS(selectEq, outcomeEq, data = MEPS2001, df = 12)

}
\references{
\insertRef{marchenko2012heckman}{ssmodels}
}
