% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/life-valuation.R
\name{valInfo.life}
\alias{valInfo.life}
\title{Providing Information for Life Item Valuation
from a marketRisk and a lifeRisk}
\usage{
\method{valInfo}{life}(object, market.risk, life.risk, total.vola = T, ...)
}
\arguments{
\item{object}{S3 object of class life.}

\item{market.risk}{S3 object of class marketRisk created using the constructor
\code{marketRisk}.}

\item{life.risk}{S3 object of class lifeRisk created using
\code{lifeRisk}.}

\item{total.vola}{a logical value, by default set to \code{TRUE}.}

\item{...}{additional arguments.}
}
\value{
a numeric value: the agggregated volatility if
  \code{total.vola = TRUE}. Otherwise the named vector of volatilities
  for each life insurance risk factor.
}
\description{
\code{valInfo} is a generic S3 method for classes
  inheriting from item. It returns sufficient information for the
  creation of the valuation function of the item.
  It returns the volatilities for life risk-factor by transforming
  the value-at-risk sensitivities provided in the \code{life} constructor.
}
