% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateParams.R
\name{random_coefmats}
\alias{random_coefmats}
\title{Create random VAR model \eqn{(dxd)} coefficient matrices \eqn{A}.}
\usage{
random_coefmats(d, how_many, scale)
}
\arguments{
\item{how_many}{how many \eqn{(dxd)} coefficient matrices \eqn{A} should be drawn?}

\item{scale}{non-diagonal elements will be drawn from mean zero normal distribution
with \code{sd=0.3/scale} and diagonal elements from one with \code{sd=0.6/scale}.
Larger scale will hence more likely result stationary coefficient matrices, but
will explore smaller area of the parameter space. Can be for example
\code{1 + log(2*mean(c((p-0.2)^(1.25), d)))}.}
}
\value{
Returns \eqn{((how_many*d^2)x1)} vector containing vectorized coefficient
 matrices \eqn{(vec(A_{1}),...,vec(A_{how_many}))}. Note that if \code{how_many==p},
 then the returned vector equals \strong{\eqn{\phi_{m}}}.
}
\description{
\code{random_coefmats} generates random VAR model coefficient matrices.
}
\keyword{internal}
