% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{check_Bt_Cpp}
\alias{check_Bt_Cpp}
\title{Check Matrix B Invertibility with C++ (Internal Function)}
\usage{
check_Bt_Cpp(all_Omegas, alpha_mt, posdef_tol)
}
\arguments{
\item{all_Omegas}{A cube (3D array) of impact matrices, with each slice being an inveritble square matrix.}

\item{alpha_mt}{A matrix of weights, with as many columns as there are slices in \code{all_Omegas}.}

\item{posdef_tol}{A strictly positive small number used as a tolerance for checking
the invertibility of the matrix. The matrix is considered non-invertible if
its determinant is less than this tolerance.}
}
\value{
A boolean value: `TRUE` if all weighted sums are invertible up to the specified
        tolerance, `FALSE` otherwise.
}
\description{
This internal function takes a cube of matrices (\code{all_Omegas}),
a matrix of weights (\code{alpha_mt}), and a numerical tolerance (\code{posdef_tol})
to check the invertibility of weighted sums of the matrices in the cube. For each row
in \code{alpha_mt}, it computes a weighted sum of matrices, and checks if this sum is
invertible by verifying that its determinant is not within the specified tolerance of zero.
}
\keyword{internal}
