% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pase_calc.R
\name{pase_calc}
\alias{pase_calc}
\title{PASE score calculator}
\usage{
pase_calc(ds, adjust_work = FALSE)
}
\arguments{
\item{ds}{data set}

\item{adjust_work}{flag to set whether to include 10b type 1.
Default is TRUE.}
}
\value{
data.frame
}
\description{
Calculates PASE score from raw questionnaire data.
}
\details{
Labelling should be as defined by the questionnaire.
02-06 should start with 0:3, 02a-06b should start with 1:4.
\subsection{Regarding work scoring}{

The score calculation manual available for the PASE questionnaire, all types
of work should be included. According to the article by
Washburn RA. et al (1999) sitting work is not included in the item 10 score.
This differentiation is added with the option to set \code{adjust_work} to
exclude item 10b category 1 work (set \code{TRUE}).
}

\subsection{Regarding output}{

Output includes sub scores as well as sums, but also to columns assessing data
quality and completeness. If any field has not been filled, \code{score_incompletes}
will return \code{TRUE}. If all measures are missing \code{score_missings} is \code{TRUE}.
If \code{adjust_work==TRUE}, 10b has to be filled, or \code{score_incompletes} will be
set \code{TRUE}.
}
}
\examples{
summary(pase_calc(stRoke::pase)[,13])

}
