% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correction_functions.R
\name{eem_raman_normalisation2}
\alias{eem_raman_normalisation2}
\title{Wrapper function to eem_raman_normalisation (eemR).}
\usage{
eem_raman_normalisation2(data, blank = "blank")
}
\arguments{
\item{data}{fluorescence data of class eemlist}

\item{blank}{defines how Raman normalisation is done (see 'Details')}
}
\value{
fluorescence data of class eemlist
}
\description{
Usually Raman normalisation is done with fluorescence data from a blank sample. Sometimes you already know a value for the Raman area. This function can do both.
}
\details{
Possible values for blank:

    "blank": normalisation is done with a blank sample. Please refer to \code{\link[eemR]{eem_raman_normalisation}}.

    numeric: normalisation is done with one value for all samples.

    data frame: normalisation is done with different values for different samples. Values are taken from a data.frame with sample names as rownames and one column containing the raman area values.
}
\examples{
data(eem_list)
# correction by blank
eems_bl <- eem_raman_normalisation2(eem_list,blank="blank")

# correction by value
eems_num <- eem_raman_normalisation2(eem_list,blank=168)
}
