% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/inspect.R
\name{inspect}
\alias{inspect}
\title{Inspect Discrete Powerlaw Distributions}
\usage{
inspect(o, plot = TRUE, guess = 1, showQ = FALSE, plothill = TRUE,
  summary = TRUE, xmax = 1e+05)
}
\arguments{
\item{o}{A discrete powerlaw object.}

\item{plot}{Logical, whether to show the plot. By default is set to TRUE.}

\item{guess}{A guess on the true value of the lower bound. By default is set to 1.}

\item{showQ}{Logical, whether to show the quantiles of the distribution. By default is set to FALSE.}

\item{plothill}{Logical, whether to show Hill plot. By default is set to TRUE.}

\item{summary}{Logical, whether to print some information about the powerlaw distribution. By default is set to TRUE.}

\item{xmax}{The maximum value to consider as candidate for the lower bound.}
}
\description{
A graphical tool to inspect discrete powerlaw distributions.
}
\examples{
x = moby
o = displo(x)
inspection = inspect(o, guess = 7)
}
\keyword{distributions}
\keyword{inspect}
\keyword{powerlaw}

