% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.model_stack}
\alias{predict.model_stack}
\title{Predicting with a model stack}
\usage{
\method{predict}{model_stack}(object, new_data, type = NULL, members = FALSE, opts = list(), ...)
}
\arguments{
\item{object}{A model stack with fitted members outputted from \code{\link[=fit_members]{fit_members()}}.}

\item{new_data}{A rectangular data object, such as a data frame.}

\item{type}{Format of returned predicted values—one of "numeric", "class",
or "prob". When NULL, \code{predict()} will
choose an appropriate value based on the model's mode.}

\item{members}{Logical. Whether or not to additionally return the predictions
for each of the ensemble members.}

\item{opts}{A list of optional arguments to the underlying predict
function passed on to \link[parsnip:predict.model_fit]{parsnip::predict.model_fit} for each member.}

\item{...}{Additional arguments. Currently ignored.}
}
\description{
Apply a model stack to create different types of predictions.
}
\section{Example Data}{


This package provides some resampling objects and datasets for use in examples
and vignettes derived from a study on 1212 red-eyed tree frog embryos!

Red-eyed tree frog (RETF) embryos can hatch earlier than their normal
7ish days if they detect potential predator threat. Researchers wanted
to determine how, and when, these tree frog embryos were able to detect
stimulus from their environment. To do so, they subjected the embryos
at varying developmental stages to "predator stimulus" by jiggling
the embryos with a blunt probe. Beforehand, though some of the embryos
were treated with gentamicin, a compound that knocks out their lateral
line (a sensory organ.) Researcher Julie Jung and her crew found that
these factors inform whether an embryo hatches prematurely or not!

Note that the data included with the stacks package is not necessarily
a representative or unbiased subset of the complete dataset, and is
only for demonstrative purposes.

\code{reg_folds} and \code{class_folds} are \code{rset} cross-fold validation objects
from \code{rsample}, splitting the training data into for the regression
and classification model objects, respectively. \code{tree_frogs_reg_test} and
\code{tree_frogs_class_test} are the analogous testing sets.

\code{reg_res_lr}, \code{reg_res_svm}, and \code{reg_res_sp} contain regression tuning results
for a linear regression, support vector machine, and spline model, respectively,
fitting \code{latency} (i.e. how long the embryos took to hatch in response
to the jiggle) in the \code{tree_frogs} data, using most all of the other
variables as predictors. Note that the data underlying these models is
filtered to include data only from embryos that hatched in response to
the stimulus.

\code{class_res_rf} and \code{class_res_nn} contain multiclass classification tuning
results for a random forest and neural network classification model,
respectively, fitting \code{reflex} (a measure of ear function) in the
data using most all of the other variables as predictors.

\code{log_res_rf} and \code{log_res_nn}, contain binary classification tuning results
for a random forest and neural network classification model, respectively,
fitting \code{hatched} (whether or not the embryos hatched in response
to the stimulus) using most all of the other variables as predictors.

See \code{?example_data} to learn more about these objects, as well as browse
the source code that generated them.
}

\examples{
\dontshow{if (rlang::is_installed("ranger") & rlang::is_installed("kernlab")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{

# see the "Example Data" section above for
# clarification on the data and tuning results
# objects used in these examples!

data(tree_frogs_reg_test)
data(tree_frogs_class_test)

# build and fit a regression model stack
reg_st <-
  stacks() \%>\%
  add_candidates(reg_res_lr) \%>\%
  add_candidates(reg_res_sp) \%>\%
  blend_predictions() \%>\%
  fit_members()

reg_st

# predict on the tree frogs testing data
predict(reg_st, tree_frogs_reg_test)

# include the predictions from the members
predict(reg_st, tree_frogs_reg_test, members = TRUE)

# build and fit a classification model stack
class_st <-
  stacks() \%>\%
  add_candidates(class_res_nn) \%>\%
  add_candidates(class_res_rf) \%>\%
  blend_predictions() \%>\%
  fit_members()
 
class_st

# predict reflex, first as a class, then as
# class probabilities
predict(class_st, tree_frogs_class_test)
predict(class_st, tree_frogs_class_test, type = "prob")

# returning the member predictions as well
predict(
  class_st, 
  tree_frogs_class_test, 
  type = "prob", 
  members = TRUE
)

}
\dontshow{\}) # examplesIf}
}
