% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_mig.R
\name{write_database,report_mig-method}
\alias{write_database,report_mig-method}
\alias{write_database.report_mig}
\title{Command line method to write the daily and monthly counts to the t_bilanmigrationjournalier_bjo table}
\usage{
\S4method{write_database}{report_mig}(object, silent = TRUE, check_for_bjo = TRUE)
}
\arguments{
\item{object}{an object of class \linkS4class{report_mig}}

\item{silent}{: TRUE to avoid messages}

\item{check_for_bjo}{: do you want to check if data are already present in the bjo table, and delete them,
this param was added otherwise connect method when called from report_mig_interannual runs in loops}
}
\value{
Nothing, just writes data into the database
}
\description{
Daily values are needed to compare migrations from year to year, by the class \link{report_mig_interannual-class}. They are added by
by this function.
}
\note{
the user is asked whether or not he wants to overwrite data only when silent is FALSE, if no
data are present in the database, the import is done anyway.
}
\examples{
\dontrun{
stacomi(database_expected=FALSE)
data("r_mig")
r_mig<-calcule(r_mig)
write_database(report_mig=r_mig,silent=FALSE)
}
}
\author{
Cedric Briand \email{cedric.briand@eptb-vilaine.fr}
}
