% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ref_par.R
\name{charge_with_filter,ref_par-method}
\alias{charge_with_filter,ref_par-method}
\alias{charge_with_filter.ref_par}
\title{Loading method for \code{ref_par referential} objects searching only those parameters existing for a DC, a Taxa, and a stage}
\usage{
\S4method{charge_with_filter}{ref_par}(object, dc_selected, taxa_selected, stage_selected)
}
\arguments{
\item{object}{An object of class \link{ref_par-class}}

\item{dc_selected}{A counting device selected for the report}

\item{taxa_selected}{The taxa selected for the report}

\item{stage_selected}{The stage selected for the report}
}
\value{
An S4 object of class \link{ref_par-class}
}
\description{
Loading method for \code{ref_par referential} objects searching only those parameters existing for a DC, a Taxa, and a stage
}
\examples{
\dontrun{
 object=new('ref_par')
charge_with_filter(object,dc_selected=6,taxa_selected=2038,stage_selected=c('AGJ','CIV'))
}
}
\author{
Cedric Briand \email{cedric.briand'at'eptb-vilaine.fr}
}
