% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1b-base-model-function.R
\name{sevt.fit}
\alias{sevt.fit}
\alias{fit.sevt}
\title{Fit a staged event tree}
\usage{
sevt.fit(sevt, data = NULL, lambda = 0, ...)

fit.sevt(sevt, data = NULL, lambda = 0, ...)
}
\arguments{
\item{sevt}{a staged event tree}

\item{data}{data.frame, contingency table, or fitted
stratified event tree}

\item{lambda}{smoothing parameter}

\item{...}{additional parameters}
}
\value{
a fitted staged event tree, that is an object of class \code{sevt}
with \code{ctables} and \code{prob} arguments.
}
\description{
Estimate transition probabilities in a staged event tree from data.
Probabilities are estimated with the relative frequencies plus,
eventually,  an additive (Laplace) smoothing.
}
\details{
The log-likelihood of the model will be recomputed and
stored in the returned object.

\code{fit.sevt} is the same as \code{sevt.fit}
and it will be probably removed in the future.
}
\examples{

#########
model <- staged_ev_tree(list(X = c("good", "bad"),
                        Y = c("high", "low")))
D <- data.frame(X = c("good", "good", "bad"),
                Y = c("high", "low", "low"))
model.fit <- sevt.fit(model, data = D, lambda = 1)
}
