% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2-plot-functions.R
\name{plot.sevt}
\alias{plot.sevt}
\title{Plot method for staged event trees}
\usage{
\method{plot}{sevt}(
  x,
  limit = 10,
  xlim = c(0, 1),
  ylim = c(0, 1),
  asp = 1,
  cex.label.nodes = 1,
  cex.label.edges = 1,
  cex.nodes = 2,
  col = NULL,
  ...
)
}
\arguments{
\item{x}{staged event tree object}

\item{limit}{maximum number of variables plotted}

\item{xlim}{graphical parameter}

\item{ylim}{graphical parameter}

\item{asp}{graphical parameter}

\item{cex.label.nodes}{graphical parameter}

\item{cex.label.edges}{graphical parameter}

\item{cex.nodes}{graphical parameter}

\item{col}{color mapping for the stages, a named list with
names equal to the variables names in the model and
vectors named with stages names as components; otherwise
if \code{col == "stages"} the stage names will be used as
colors; otherwise if \code{col} is a function it will take
as input a vector of stages and output the corresponding colors.}

\item{...}{additional graphical parameters to be passed to
\code{points}, \code{lines}, \code{title},
\code{text} and \code{plot.window}.}
}
\description{
\code{plot.sevt} is the plot method for staged event tree
objects. It allows easy plotting for staged event tree with some
options, mainly different ways to specify colors for the stages (see
examples).
}
\examples{

data("PhDArticles")
mod <- bj.sevt(full(PhDArticles))

### simple plotting
plot(mod)

### removing lables from nodes and edges and fill nodes
plot(mod, cex.label.nodes = 0, cex.label.edges = 0, pch = 16)

### reduce nodes size
plot(mod, cex.nodes = 1)

### change line width and nodes style
plot(mod, lwd = 3, pch = 5)

### changing palette
plot(mod, col = function(s) heat.colors(length(s)))

### or changing global palette
palette(hcl.colors(10, "Harmonic"))
plot(mod)

### manually give stages colors
simple <- naive.sevt(full(PhDArticles, lambda = 1))
#### simple has 2 stages per variable "1" and "2"
col <- lapply(simple$stages, function(s) {
  c("1" = "purple", "2" = "cyan")
})
plot(simple, col = col)
}
