% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2-plot-functions.R
\name{plot.ceg}
\alias{plot.ceg}
\title{igraph's plotting for CEG}
\usage{
\method{plot}{ceg}(x, col = NULL, ignore = x$name_unobserved, layout = NULL, ...)
}
\arguments{
\item{x}{an object of class \code{\link{ceg}}.}

\item{col}{colors specification see \code{\link{plot.sevt}}.}

\item{ignore}{vector of stages which will be ignored and left untouched,
by default the name of the unobserved stages stored in
\code{x$name_unobserved}.}

\item{layout}{an igraph layout.}

\item{...}{additional arguments passed to \code{plot.igraph}.}
}
\description{
igraph's plotting for CEG
}
\details{
This function is a simple wrapper around
\pkg{igraph}'s \code{plot.igraph}.
The ceg object is converted to an igraph object
by firstly obtaining the adjacency matrix representation
with \code{\link{ceg2adjmat}}.
If not specified, the default \code{layout} used is
a rotated \code{layout.reingold.tilford}.

We use \code{palette()} as palette for
the \pkg{igraph} plotting, while \code{plot.igraph} uses
as default a different palette. This is to allow matching
stages colors between \code{plot.ceg}
and \code{\link{plot.sevt}}.
}
\examples{
\dontrun{
 model <- stages_bhc(full(Titanic))
 model.ceg <- ceg(model)
 plot(model.ceg, edge.arrow.size = 0.1, vertex.label.dist = -2)
 }
}
