% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factors.R
\name{cut_stars}
\alias{cut_stars}
\alias{cut.array}
\alias{cut.matrix}
\alias{cut.stars}
\title{cut methods for stars objects}
\usage{
\method{cut}{array}(x, breaks, ...)

\method{cut}{matrix}(x, breaks, ...)

\method{cut}{stars}(x, breaks, ...)
}
\arguments{
\item{x}{see \link[base]{cut}}

\item{breaks}{see \link[base]{cut}}

\item{...}{see \link[base]{cut}}
}
\value{
an array or matrix with a \code{levels} attribute; see details
}
\description{
cut methods for stars objects
}
\details{
R's \code{factor} only works for vectors, not for arrays or matrices. This is a work-around (or hack?) to keep the factor levels generated by \code{cut} and use them in plots.
}
\examples{
tif = system.file("tif/L7_ETMs.tif", package = "stars")
x = read_stars(tif)
cut(x, c(0, 50, 100, 255))
cut(x[,,,1], c(0, 50, 100, 255))
plot(cut(x[,,,1], c(0, 50, 100, 255)))
tif = system.file("tif/L7_ETMs.tif", package = "stars")
x1 = read_stars(tif)
(x1_cut = cut(x1, breaks = c(0, 50, 100, Inf)))  # shows factor in summary
plot(x1_cut[,,,c(3,6)]) # propagates through [ and plot
}
