/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import blbutil.Pair;
import blbutil.SampleFileIt;
import blbutil.Utilities;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.function.Supplier;
import vcf.GTRec;
import vcf.GeneticMap;
import vcf.Marker;
import vcf.Samples;
import vcf.Window;

public class WindowIt<E extends GTRec>
implements SampleFileIt<Window<E>> {
    private final File file;
    private final Samples samples;
    private final BlockingQueue<Window<E>> q;
    private final Reader reader;
    private Window<E> currentWind;

    public static <E extends GTRec> WindowIt<E> newInstance(Supplier<SampleFileIt<E>> supplier, GeneticMap geneticMap, float f, float f2) {
        ArrayBlockingQueue<Window<E>> arrayBlockingQueue = new ArrayBlockingQueue<Window<E>>(1);
        ArrayBlockingQueue<Pair<File, Samples>> arrayBlockingQueue2 = new ArrayBlockingQueue<Pair<File, Samples>>(1);
        Reader reader = new Reader(supplier, arrayBlockingQueue, arrayBlockingQueue2, geneticMap, f, f2);
        Thread thread = new Thread(reader);
        thread.setDaemon(true);
        thread.start();
        Pair<File, Samples> pair = WindowIt.takeFromQ(arrayBlockingQueue2);
        return new WindowIt(pair.first(), pair.second(), reader, arrayBlockingQueue);
    }

    private WindowIt(File file, Samples samples, Reader<E> reader, BlockingQueue<Window<E>> blockingQueue) {
        this.file = file;
        this.samples = samples;
        this.q = blockingQueue;
        this.reader = reader;
    }

    public GeneticMap genMap() {
        return this.reader.genMap;
    }

    @Override
    public boolean hasNext() {
        return this.currentWind == null || !this.currentWind.lastWindow();
    }

    @Override
    public Window<E> next() {
        if (!this.hasNext()) {
            throw new IllegalStateException("canAdvanceWindow()==false");
        }
        this.currentWind = WindowIt.takeFromQ(this.q);
        return this.currentWind;
    }

    private static <E> E takeFromQ(BlockingQueue<E> blockingQueue) {
        E e = null;
        try {
            e = blockingQueue.take();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        return e;
    }

    @Override
    public File file() {
        return this.file;
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public void close() {
        this.reader.terminate();
        while (this.hasNext()) {
            this.next();
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(1100);
        stringBuilder.append(this.getClass().toString());
        return stringBuilder.toString();
    }

    private static class Reader<V extends GTRec>
    implements Runnable {
        private final Supplier<SampleFileIt<V>> supplier;
        private final GeneticMap genMap;
        private final float windowCM;
        private final float overlapCM;
        private final BlockingQueue<Window<V>> q;
        private final BlockingQueue<Pair<File, Samples>> q1;
        private volatile boolean finished;

        public Reader(Supplier<SampleFileIt<V>> supplier, BlockingQueue<Window<V>> blockingQueue, BlockingQueue<Pair<File, Samples>> blockingQueue2, GeneticMap geneticMap, float f, float f2) {
            if (geneticMap == null) {
                throw new NullPointerException(GeneticMap.class.toString());
            }
            if (f2 < 0.0f || !Float.isFinite(f2)) {
                throw new IllegalArgumentException(String.valueOf(f2));
            }
            if (f <= f2 || !Float.isFinite(f)) {
                throw new IllegalArgumentException(String.valueOf(f));
            }
            this.supplier = supplier;
            this.genMap = geneticMap;
            this.windowCM = f;
            this.overlapCM = f2;
            this.q = blockingQueue;
            this.q1 = blockingQueue2;
            this.finished = false;
        }

        public void terminate() {
            this.finished = true;
        }

        @Override
        public void run() {
            try (SampleFileIt<V> sampleFileIt = this.supplier.get();){
                this.q1.add(new Pair<File, Samples>(sampleFileIt.file(), sampleFileIt.samples()));
                if (!sampleFileIt.hasNext()) {
                    throw new IllegalArgumentException("No VCF records after filtering");
                }
                ArrayList<GTRec> arrayList = new ArrayList<GTRec>(10000);
                GTRec gTRec = (GTRec)sampleFileIt.next();
                Window<GTRec> window = null;
                double d = Double.NaN;
                while (gTRec != null) {
                    int n = gTRec.marker().chromIndex();
                    if (window == null || window.chromIndex() != n) {
                        d = this.genMap.genPos(gTRec.marker()) + (double)this.windowCM;
                    } else {
                        d += (double)(this.windowCM - this.overlapCM);
                        window.addRecords(arrayList, window.nextOverlap(), window.nMarkers());
                    }
                    int n2 = this.genMap.basePos(n, d);
                    int n3 = arrayList.size();
                    arrayList.add(gTRec);
                    GTRec gTRec2 = gTRec = sampleFileIt.hasNext() ? (GTRec)sampleFileIt.next() : null;
                    while (gTRec != null && gTRec.marker().chromIndex() == n && gTRec.marker().pos() < n2) {
                        arrayList.add(gTRec);
                        gTRec = sampleFileIt.hasNext() ? (GTRec)sampleFileIt.next() : null;
                    }
                    if (this.finished) {
                        gTRec = null;
                    }
                    window = this.addWindowToQ(n, n3, arrayList, gTRec);
                    arrayList.clear();
                }
            }
            catch (Throwable throwable) {
                Utilities.exit(throwable);
            }
        }

        private Window<V> addWindowToQ(int n, int n2, List<V> list, V v) {
            boolean bl = v == null;
            boolean bl2 = v == null || v.marker().chromIndex() != n;
            int n3 = this.overlapStart(bl2, list, this.overlapCM);
            Window<V> window = new Window<V>(list, n2, n3, bl2, bl);
            try {
                this.q.put(window);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            return window;
        }

        private int overlapStart(boolean bl, List<V> list, float f) {
            if (list.isEmpty() || bl) {
                return list.size();
            }
            Marker marker = ((GTRec)list.get(list.size() - 1)).marker();
            double d = this.genMap.genPos(marker);
            double d2 = d - (double)f;
            int n = this.genMap.basePos(marker.chromIndex(), d2);
            int n2 = 0;
            int n3 = list.size() - 1;
            while (n2 <= n3) {
                int n4 = n2 + n3 >>> 1;
                int n5 = ((GTRec)list.get(n4)).marker().pos();
                if (n5 < n) {
                    n2 = n4 + 1;
                    continue;
                }
                if (n5 > n) {
                    n3 = n4 - 1;
                    continue;
                }
                return this.firstIndexWithPos(list, n4);
            }
            assert (n3 < n2);
            return this.firstIndexWithPos(list, n3);
        }

        private int firstIndexWithPos(List<V> list, int n) {
            if (n < 0) {
                return 0;
            }
            int n2 = ((GTRec)list.get(n)).marker().pos();
            while (n > 0 && ((GTRec)list.get(n - 1)).marker().pos() == n2) {
                --n;
            }
            return n;
        }
    }
}

