/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import java.util.Arrays;
import java.util.stream.IntStream;
import vcf.GTRec;
import vcf.Marker;
import vcf.Samples;
import vcf.VcfRecGTParser;

public final class LowMafGTRec
implements GTRec {
    private final Marker marker;
    private final Samples samples;
    private final int nHaps;
    private final int majorAllele;
    private final int[][] hapIndices;
    private final int[] missingSamples;
    private final boolean isPhased;

    public LowMafGTRec(VcfRecGTParser.HapListRep hapListRep) {
        this.marker = hapListRep.marker();
        this.samples = hapListRep.samples();
        this.nHaps = this.samples.size() << 1;
        this.majorAllele = hapListRep.majorAllele();
        this.hapIndices = hapListRep.hapLists(true);
        this.missingSamples = hapListRep.missingSamples();
        this.isPhased = hapListRep.isPhased();
    }

    @Override
    public boolean isPhased(int n) {
        if (n < 0 || n >= this.samples().size()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.isPhased;
    }

    @Override
    public boolean isPhased() {
        return this.isPhased;
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public int size() {
        return this.nHaps;
    }

    @Override
    public Marker marker() {
        return this.marker;
    }

    @Override
    public int allele1(int n) {
        return this.get(n << 1);
    }

    @Override
    public int allele2(int n) {
        return this.get(n << 1 | 1);
    }

    @Override
    public int get(int n) {
        if (n < 0 || n >= this.nHaps) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        for (int i = 0; i < this.hapIndices.length; ++i) {
            if (i == this.majorAllele || Arrays.binarySearch(this.hapIndices[i], n) < 0) continue;
            return i;
        }
        return Arrays.binarySearch(this.missingSamples, n >> 1) >= 0 ? -1 : this.majorAllele;
    }

    @Override
    public int[] alleles() {
        int n2;
        int[] nArray = IntStream.range(0, this.nHaps).map(n -> this.majorAllele).toArray();
        for (int i = 0; i < this.hapIndices.length; ++i) {
            if (i == this.majorAllele) continue;
            int[] nArray2 = this.hapIndices[i];
            int n3 = nArray2.length;
            for (int j = 0; j < n3; ++j) {
                n2 = nArray2[j];
                nArray[n2] = i;
            }
        }
        for (int j : this.missingSamples) {
            n2 = j << 1;
            int n4 = n2 | 1;
            nArray[n2] = -1;
            nArray[n4] = -1;
        }
        return nArray;
    }

    public int majorAllele() {
        return this.majorAllele;
    }

    public int alleleCount(int n) {
        if (n == this.majorAllele) {
            int n2 = this.nHaps - (this.missingSamples.length << 1);
            for (int i = 0; i < this.hapIndices.length; ++i) {
                if (i == this.majorAllele) continue;
                n2 -= this.hapIndices.length;
            }
            return n2;
        }
        return this.hapIndices[n].length;
    }

    public String toString() {
        return GTRec.toVcfRec(this);
    }
}

