% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createVarComp.R
\name{predict.varComp}
\alias{predict.varComp}
\title{Predictions based on a fitted varComp model.}
\usage{
\method{predict}{varComp}(
  object,
  ...,
  predictLevel = c("genotype", "trial", object$nestingFactor)
)
}
\arguments{
\item{object}{An object of class varComp.}

\item{...}{Not used.}

\item{predictLevel}{A character string, the level at which prediction should
be made. Either "genotype" for prediction at genotype level, "trial" for
predictions at genotype x trial level or the variable used as nesting factor
for predictions at the level of genotype x nestingFactor level.}
}
\value{
A data.frame with predictions.
}
\description{
Predictions are made based on the fitted model in the varComp object.
These predictions can be at genotype level, at genotype x trial level or at
the level of genotype x nestingFactor. If the model was fitted with trial as
year x location then genotype x trial level becomes genotype x year x location.
}
\examples{
## Fit a mixed model.
geVarComp <- gxeVarComp(TD = TDMaize, trait = "yld")

## Predictions at genotype level.
predGeno <- predict(geVarComp)
head(predGeno)

## Predictions at genotype x trial level.
predGenoTrial <- predict(geVarComp, predictLevel = "trial")
head(predGenoTrial)

}
\seealso{
Other Mixed model analysis: 
\code{\link{CRDR}()},
\code{\link{correlations}()},
\code{\link{diagnostics}()},
\code{\link{gxeVarComp}()},
\code{\link{herit}()},
\code{\link{plot.varComp}()},
\code{\link{vc}()}
}
\concept{Mixed model analysis}
