% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readRABBIT.R
\name{readRABBIT}
\alias{readRABBIT}
\title{Read IBD probabilities}
\usage{
readRABBIT(infile, pedFile = NULL)
}
\arguments{
\item{infile}{A character string, a link to a .csv file with IBD
probabilities. Compressed .csv files with extension ".gz" or ".bz2" are
supported as well.}

\item{pedFile}{A character string, a link to a .csv file with pedigree
information as used by RABBIT as input. Compressed .csv files with extension
".gz" or ".bz2" are supported as well.}
}
\value{
An \code{IBDprob} object with map and markers corresponding to the
imported information in the imported .csv file.
}
\description{
Read a file with IBD probabilities computed by the RABBIT software package.
It is possible to additionally read the pedigree file that is also used by
RABBIT. Reading this file allows for plotting the pedigree.
}
\examples{
\dontrun{
## Read RABBIT data for barley.
genoFile <- system.file("extdata/barley", "barley_magicReconstruct.zip",
                       package = "statgenIBD")
barleyIBD <- readRABBIT(unzip(genoFile, exdir = tempdir()))
}

}
\references{
Zheng, Chaozhi, Martin P Boer, and Fred A Van Eeuwijk.
“Recursive Algorithms for Modeling Genomic Ancestral Origins in a Fixed
Pedigree.” G3 Genes|Genomes|Genetics 8 (10): 3231–45.
https://doi.org/10.1534/G3.118.200340.
}
