% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/get_ncdc_station_info.R
\name{get_ncdc_station_info}
\alias{get_ncdc_station_info}
\title{Get listing of stations based on location or time bounds}
\usage{
get_ncdc_station_info(startyear = NULL, endyear = NULL, lower_lat = NULL,
  upper_lat = NULL, lower_lon = NULL, upper_lon = NULL)
}
\arguments{
\item{startyear}{the starting year for the collected data.}

\item{endyear}{the ending year for the collected data.}

\item{lower_lat}{the lower bound of the latitude for a bounding box.}

\item{upper_lat}{the upper bound of the latitude for a bounding box.}

\item{lower_lon}{the lower bound of the longitude for a bounding box.}

\item{upper_lon}{the upper bound of the longitude for a bounding box.}
}
\description{
Obtain a data frame containing information on hourly
meteorological station by searching via a geographical bounding box and/or
via time bounds for data availability.
}
\examples{
\dontrun{
# Obtain a data frame with all available met stations
get_ncdc_station_info()

# Get a listing of met stations within a geographical
# bounding box
get_ncdc_station_info(lower_lat = 49.000,
                      upper_lat = 49.500,
                      lower_lon = -123.500,
                      upper_lon = -123.000)

# List all stations with data available for the 2005
# and 2006 years
get_ncdc_station_info(startyear = 2005,
                      endyear = 2006)
}
}

