% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.mean1}
\alias{ci.mean1}
\title{Confidence interval for a single mean}
\usage{
ci.mean1(alpha, m, sd, n)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m}{sample mean}

\item{sd}{sample standard deviation}

\item{n}{sample size}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimated mean
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a confidence interval for a population mean using the sample
mean, sample standard deviation, and sample size. Use the t.test function
for raw data input.
}
\examples{
ci.mean1(.05, 24.5, 3.65, 40)

# Should return:
#        Estimate        SE       LL       UL
# [1,]       24.5 0.5771157 23.33267 25.66733
 

}
\references{
\insertRef{Snedecor1980}{statpsych}
}
