% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.ratio.median.ps}
\alias{ci.ratio.median.ps}
\title{Confidence interval for a paired-samples median ratio}
\usage{
ci.ratio.median.ps(alpha, y1, y2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{y1}{vector of scores for measurement 1}

\item{y2}{vector of scores for measurement 2}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Median1 - estimated median from measurement 1
\item Median2 - estimated median from measurement 2
\item Median1/Median2 - estimated ratio of medians
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a confidence interval for a ratio of population medians in a
paired-samples design.
}
\examples{
y1 <- c(21, 4, 9, 12, 35, 18, 10, 22, 24, 1, 6, 8, 13, 16, 19)
y2 <- c(67, 28, 30, 28, 52, 40, 25, 37, 44, 10, 14, 20, 28, 40, 51)
ci.ratio.median.ps(.05, y1, y2)

# Should return:
#         Median1  Median2   Median1/Median2        LL        UL
# [1,]         13       30         0.4333333 0.3094838 0.6067451


}
\references{
\insertRef{Bonett2020b}{statpsych}
}
