% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{pi.var.upper}
\alias{pi.var.upper}
\title{Upper prediction limit for an estimated variance}
\usage{
pi.var.upper(alpha, var, n1, n2)
}
\arguments{
\item{alpha}{alpha value for upper 1-alpha confidence}

\item{var}{estimated variance from prior study}

\item{n1}{sample size used to estimate variance}

\item{n2}{planned sample size of future study}
}
\value{
Returns an upper prediction estimate (UL) of an estimated variance in a future study
}
\description{
Computes an approximate upper prediction limit for the estimated variance
in a future study for a planned sample size. The prediction limit uses a
variance estimate from a prior study. The upper variance prediction limit
is useful as a variance planning value for the sample size required to obtain
a confidence interval with desired width. This strategy for specifying a
variance planning value is useful in applications where the population variance
in the prior study is assumed to be similar to the population variance in the
planned study. This variance planning value can be used to revise the planned
sample size in the future study.
}
\examples{
pi.var.upper(.2, 15, 40, 100)

# Should return:
#           UL
# [1] 18.78522
 

}
