% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{ci.cor.dep}
\alias{ci.cor.dep}
\title{Confidence interval for a difference in dependent Pearson correlations}
\usage{
ci.cor.dep(alpha, cor1, cor2, cor12, n)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{cor1}{estimated Pearson correlation between y and x1}

\item{cor2}{estimated Pearson correlation between y and x2}

\item{cor12}{estimated Pearson correlation between x1 and x2}

\item{n}{sample size}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimated correlation difference
\item SE - recovered standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a confidence interval for a difference in population Pearson
correlations that are estimated from the same sample and have one
variable in common. A bias adjustmentment is used to reduce the bias
of each Fisher transformed correlation. An approximate standard error
is recovered from the confidence interval.
}
\examples{
ci.cor.dep(.05, .396, .179, .088, 166)

# Should return:
# Estimate        SE         LL       UL
#    0.217 0.1026986 0.01323072 0.415802
 

}
\references{
\insertRef{Zou2007}{statpsych}
}
