% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.mad1}
\alias{ci.mad1}
\title{Confidence interval for a single mean absolute deviation}
\usage{
ci.mad1(alpha, y)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{y}{vector of scores}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimated mean absolute deviation
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a confidence interval for a population mean absolute deviation
from the median (MAD). The MAD is a robust alternative to the standard
deviation.
}
\examples{
y <- c(30, 20, 15, 10, 10, 60, 20, 25, 20, 30, 10, 5, 50, 40, 
       20, 10, 0, 20, 50)
ci.mad1(.05, y)

# Should return:
# Estimate       SE       LL       UL
#     12.5 2.876103 7.962667 19.62282


}
\references{
\insertRef{Bonett2003b}{statpsych}
}
