% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{size.supinf.mean2}
\alias{size.supinf.mean2}
\title{Sample size for a 2-group mean superiority or noninferiority test}
\usage{
size.supinf.mean2(alpha, pow, var, es, h)
}
\arguments{
\item{alpha}{alpha level for hypothesis test}

\item{pow}{desired power}

\item{var}{planning value of average within-group variance}

\item{es}{planning value of mean difference}

\item{h}{upper or lower limit for range of practical equivalence}
}
\value{
Returns the required sample size for each group
}
\description{
Computes the sample size in each group (assuming equal sample sizes)
required to perform a superiority or noninferiority test for the difference
in population means with desired power in a 2-group design. For a
superiority test, specify the upper limit (h) for the range of practical
equivalence and specify an effect size (es) such that es > h. For a
noninferiority test, specify the lower limit (-h) for the range of
practical equivalence and specify an effect size such that es > -h.
Set the variance planning value to the largest value within a plausible
range for a conservatively large sample size.
}
\examples{
size.supinf.mean2(.05, .80, 225, 9, 4)

# Should return:
# Sample size per group 
#                   143
 

}
