% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{size.ci.cor}
\alias{size.ci.cor}
\title{Sample size for a Pearson or partial correlation confidence interval}
\usage{
size.ci.cor(alpha, cor, s, w)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{cor}{planning value of correlation}

\item{s}{number of control variables}

\item{w}{desired confidence interval width}
}
\value{
Returns the required sample size
}
\description{
Computes the sample size required to estimate a population Pearson or
partial correlation with desired confidence interval precision.
Set s = 0 for a Pearson correlation. Set the correlation planning value
to the smallest absolute value within a plausible range for a conservatively
large sample size.
}
\examples{
size.ci.cor(.05, .362, 0, .25)

# Should return:
# Sample size
#         188
 

}
\references{
\insertRef{Bonett2000}{statpsych}
}
