% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{pi.var.upper}
\alias{pi.var.upper}
\title{Upper prediction limit for an estimated variance}
\usage{
pi.var.upper(alpha, var, n0, n)
}
\arguments{
\item{alpha}{alpha value for upper 1-alpha confidence}

\item{var}{estimated variance from prior study}

\item{n0}{sample size used to estimate variance}

\item{n}{planned sample size of future study}
}
\value{
Returns an upper prediction estimate (UL) of an estimated variance in a future study
}
\description{
Computes an upper prediction limit for the estimated variance in a
future study for a planned sample size. The prediction limit uses a
variance estimate from a prior study. Several confidence interval
sample size functions in this package require a planning value of the
estimated variance that is expected in the planned study. The upper variance
prediction limit is useful as a variance planning value for the sample size
required to obtain a confidence interval with desired width. This strategy
for specifying a variance planning value is useful in applications where the
population variance in the prior study is assumed to be very similar to the
population variance in the planned study. This function will be replaced with
pi.var which computes both one-sided and two-sided prediction limits.
}
\examples{
pi.var.upper(.05, 15, 40, 100)

# Should return:
#      UL
# 23.9724
 

}
\references{
\insertRef{Hahn1972}{statpsych}
}
