% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{size.ci.slope}
\alias{size.ci.slope}
\title{Sample size for a slope confidence interval}
\usage{
size.ci.slope(alpha, evar, x, w)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{evar}{planning value of within group (error) variance}

\item{x}{vector of x values of the quantitative factor}

\item{w}{desired confidence interval width}
}
\value{
Returns the required total sample size
}
\description{
Computes the total sample size required to estimate a population slope with
desired confidence interval precision in a between-subjects design with a
quantitative factor. In an experimental design, the total sample size
would be allocated to the levels of the quantitative factor and it might
be necessary to increase the total sample size to achieve equal sample
sizes. Set the error variance planning value to the largest value within
a plausible range for a conservatively large sample size.
}
\examples{
x <- c(2, 5, 8)
size.ci.slope(.05, 31.1, x, 1)

# Should return:
# Total sample size
#                83
 

}
