#' statsr: A companion package for Statistics with R 
#'
#' R package to support the online open access book "An Introduction
#' to Bayesian Thinking" available at 
#' \url{https://StatsWithR.github.io/book} and videos for the Coursera "Statistics with
#' R" Specialization.  The package includes data sets, functions
#' and Shiny Applications for learning frequentist and Bayesian
#' statistics with R.  The two main functions for inference and decision making are
#' `inference` and `bayes_inference`  which support  
#' confidence/credible intervals and hypothesis testing with one sample or two samples
#' from Gaussian and Bernoulli populations.   Shiny apps are used to illustrate how prior
#' hyperparameters or changes in the data may influence posterior distributions.
#' 
#' See \url{https://github.com/StatsWithR/statsr} for the development version and 
#' additional information or for additional background and illustrations of functions
#' the online book  \url{https://StatsWithR.github.io/book}.
#'
#' @docType package
#' @name statsr
#' @import stats
#' @import graphics
#' @import ggplot2
#' @import shiny

NULL