% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_baseline.R
\name{compute_baseline}
\alias{compute_baseline}
\title{Compute baseline processes.}
\usage{
compute_baseline(
  alpha,
  delta_lower,
  delta_upper,
  psi_fn_list = generate_sub_G_fn(),
  v_min = 1,
  k_max = 200,
  tol = 1e-10
)
}
\arguments{
\item{alpha}{ARL parameter in (0,1)}

\item{delta_lower}{Lower bound of target Delta. It must be positive and smaller than or equal to \code{delta_upper}.}

\item{delta_upper}{Upper bound of target Delta. It must be positive and larger than or equal to \code{delta_lower}.}

\item{psi_fn_list}{A list of R functions that computes psi and psi_star functions. Can be generated by \code{generate_sub_G_fn()} or counterparts for sub_B and sub_E.}

\item{v_min}{A lower bound of v function in the baseline process. Default is \code{1}.}

\item{k_max}{Positive integer to determine the maximum number of baselines. Default is \code{200}.}

\item{tol}{Tolerance of root-finding, positive numeric. Default is 1e-10.}
}
\value{
A list of 1. Parameters of baseline processes, 2. Mixing weights, 3. Auxiliary values for computation.
}
\description{
Compute parameters to build baseline processes.
}
