% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_var_info.R
\name{get_var_info}
\alias{get_var_info}
\alias{gvi}
\title{Get a small data frame of the variable label and values.}
\usage{
get_var_info(.data, x)

gvi(...)
}
\arguments{
\item{.data}{a data frame}

\item{x}{a column within the data frame}

\item{...}{optional, only to make the shortcut (\code{gvi}) work}
}
\value{
If the column in the data frame is not labelled, the function returns a message communicating
the absence of labels. If the column in the data frame is labelled, the function returns
a small data frame communicating the \code{var_label()} output (\code{var}), the (often but not always)
numeric "code" coinciding with with the label (\code{code}), and the "label" attached to it (\code{label}).
}
\description{
\code{get_var_info()} allows you to peek at your labelled data,
extracting a given column's variable labels. The intended use here is mostly
"peeking" for the purpose of recoding column's in the absence of a codebook or
other form of documentation. \code{gvi()} is a shortcut for this function.
}
\details{
This function leans on \code{var_label()} and \code{val_label()} in the
\code{labelled} package, which is a dependency for this package. The function
is designed to be used in a "pipe."
}
\examples{

library(tibble)
library(dplyr)
library(magrittr)

ess9_labelled \%>\% get_var_info(netusoft) # works, as intended
ess9_labelled \%>\% get_var_info(cntry) # works, as intended
ess9_labelled \%>\% get_var_info(ess9round) # barks at you; data are not labelled

}
