% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_1d_smooth.R
\name{plot_1d_smooth}
\alias{plot_1d_smooth}
\title{Plots a 1-Dimensional GAM smooth}
\usage{
plot_1d_smooth(mod, ncol = NULL, nrow = NULL, fills = "lightblue")
}
\arguments{
\item{mod}{a GAM model with smooths created using the \code{mgcv} package}

\item{ncol}{the number of columns in the compound plot}

\item{nrow}{the number of rows in the compound plot}

\item{fills}{the fill colours (single or vector)}
}
\value{
A compound plot of the GAM 1-dimensional smooths (rendered using \code{cowplot::plot_grid()}).
}
\description{
Plots a 1-Dimensional GAM smooth
}
\examples{
library(mgcv)
library(ggplot2)
library(dplyr)
library(cowplot)
# 1. from the `mgcv` `gam` function help
set.seed(2) ## simulate some data...
dat <- gamSim(1,n=400,dist="normal",scale=2)
b <- gam(y~s(x0)+s(x1)+s(x2)+s(x3),data=dat)
plot_1d_smooth(b, ncol = 2, fills = c("lightblue", "lightblue3"))
dev.off()
# 2. using a TVC
data(productivity)
data = productivity |> mutate(Intercept = 1)
gam.tvc.mod = gam(privC ~ 0 + Intercept +
                  s(year, bs = 'gp', by = Intercept) +
                  unemp + s(year, bs = "gp", by = unemp) +
                  pubC + s(year, bs = "gp", by = pubC),
                  data = data)
plot_1d_smooth(gam.tvc.mod, fills = "lightblue")
}
