% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_rotor_grids.R
\name{get_x_grid}
\alias{get_x_grid}
\title{Grid of horizontal distances from points in the rotor circle to its vertical
axis}
\usage{
get_x_grid(xinc = 0.05, yinc = 0.05)
}
\arguments{
\item{xinc, yinc}{numeric values, the grid increments along the y-axis and
x-axis (i.e. grid cell dimensions)}
}
\value{
A 2D array giving a grid of horizontal distances \eqn{x} from rotor's
vertical axis, expressed as the proportion of rotor radius (i.e. \eqn{[0,
  1]}), for the left-half of the rotor circle area.
}
\description{
Taking the center of the rotor circle as the origin,
\code{get_x_grid} generates a grid containing horizontal distances \eqn{x}
(by \code{xinc} increments) from the y-axis up to the outer edge of the
rotor circle, at equidistant height bands \eqn{y} (by \code{yinc}
increments) between minimum and maximum rotor height.

Distances are expressed as proportion of rotor radius (i.e. \eqn{x} is
dimensionless).

Returned grid represents the left-half of the rotor's circle.
}
\examples{
get_x_grid(xinc=0.05,yinc=0.05)

}
