% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{createRandomEffectsDataset}
\alias{createRandomEffectsDataset}
\title{Create a random effects dataset object}
\usage{
createRandomEffectsDataset(group_labels, basis, variance_weights = NULL)
}
\arguments{
\item{group_labels}{Vector of group labels}

\item{basis}{Matrix of bases used to define the random effects regression (for an intercept-only model, pass an array of ones)}

\item{variance_weights}{(Optional) Vector of observation-specific variance weights}
}
\value{
\code{RandomEffectsDataset} object
}
\description{
Create a random effects dataset object
}
\examples{
rfx_group_ids <- sample(1:2, size = 100, replace = TRUE)
rfx_basis <- matrix(rnorm(3*100), ncol = 3)
weight_vector <- rnorm(100)
rfx_dataset <- createRandomEffectsDataset(rfx_group_ids, rfx_basis)
rfx_dataset <- createRandomEffectsDataset(rfx_group_ids, rfx_basis, weight_vector)
}
