% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gains_rate.R
\name{gains_rate}
\alias{gains_rate}
\title{Calculate Growth Rate From a Vector of Gains}
\usage{
gains_rate(gains, units.rate = NULL)
}
\arguments{
\item{gains}{Numeric matrix with 1 column of gains for each investment (can 
be a vector if there is only one).}

\item{units.rate}{Numeric value specifying the number of units for growth 
rate calculation, if you want something other than total growth. For 
annualized growth rate, set to 252 if \code{gains} has daily gains, 12 if 
\code{gains} has monthly gains, etc.}
}
\value{
Numeric value if \code{gains} is a vector, numeric matrix if 
\code{gains} is a matrix.
}
\description{
The formula is simply: \code{prod(gains + 1) - 1}. If \code{units.rate} is 
specified, then it converts to x-unit growth rate.
}
\examples{
# Create vector of daily gains for a hypothetical stock
daily.gains <- c(-0.02, -0.01, 0.01, 0.02, 0.01)

# Overall growth is 0.95\%
gains_rate(daily.gains)

# Average daily growth is 0.19\%
gains_rate(daily.gains, 1)

# Corresponds to 61.0\% annual growth
gains_rate(daily.gains, 252)


}
