% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stopdetection-package.R
\docType{package}
\name{stopdetection-package}
\alias{stopdetection}
\alias{stopdetection-package}
\title{stopdetection: Stop Detection in Timestamped Trajectory Data using Spatiotemporal Clustering}
\description{
Trajectory data formed by human or animal movement is often marked by periods of movement interspersed with periods of standing still. It is often of interest to researchers to separate geolocation trajectories of latitude/longitude points by clustering consecutive locations to produce a model of this behavior. This package implements the Stay Point detection algorithm originally described in Ye (2009) \doi{10.1109/MDM.2009.11} that uses time and distance thresholds to characterize spatial regions as 'stops'. This package also implements the concept of merging described in Montoliu (2013) \doi{10.1007/s11042-011-0982-z} as stay point region estimation, which allows for clustering of temporally adjacent stops for which distance between the midpoints is less than the provided threshold. GPS-like data from various sources can be used, but the temporal thresholds must be considered with respect to the sampling interval, and the spatial thresholds must be considered with respect to the measurement error.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/daniellemccool/stopdetection}
  \item Report bugs at \url{https://github.com/daniellemccool/stopdetection/issues}
}

}
\author{
\strong{Maintainer}: McCool Danielle \email{d.m.mccool@uu.nl} (\href{https://orcid.org/0000-0002-7055-7539}{ORCID})

}
\keyword{internal}
