% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.stlgcppm.R
\name{summary.stlgcppm}
\alias{summary.stlgcppm}
\title{Summary of a fitted LGCP model}
\usage{
\method{summary}{stlgcppm}(object, ...)
}
\arguments{
\item{object}{An object of class \code{stlgcppm}}

\item{...}{additional unused argument}
}
\description{
The function Summarises the main information on the fitted model.
 provided. In this case of local parameters (both first- and second-order),
  the summary function contains information on
 their distributions.
}
\examples{
\dontrun{

catsub <- stp(greececatalog$df[1:100, ])

lgcp1 <- stlgcppm(catsub)

summary(lgcp1)

}


}
\references{
D'Angelo, N., Adelfio, G., and Mateu, J. (2023). Locally weighted minimum contrast estimation for spatio-temporal log-Gaussian Cox processes. Computational Statistics & Data Analysis, 180, 107679.

Siino, M., Adelfio, G., and Mateu, J. (2018). Joint second-order parameter estimation for spatio-temporal log-Gaussian Cox processes. Stochastic environmental research and risk assessment, 32(12), 3525-3539.
}
\seealso{
\link{stlgcppm}, \link{print.stlgcppm}, \link{localsummary.stlgcppm},
\link{plot.stlgcppm}, \link{localplot.stlgcppm}
}
\author{
Nicoletta D'Angelo and Giada Adelfio
}
