% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerstress.R
\name{powerStressMin}
\alias{powerStressMin}
\title{Power Stress SMACOF}
\usage{
powerStressMin(
  delta,
  kappa = 1,
  lambda = 1,
  nu = 1,
  weightmat = 1 - diag(nrow(delta)),
  init = NULL,
  ndim = 2,
  acc = 1e-10,
  itmax = 50000,
  verbose = FALSE
)
}
\arguments{
\item{delta}{dist object or a symmetric, numeric data.frame or matrix of distances}

\item{kappa}{power of the transformation of the fitted distances; defaults to 1}

\item{lambda}{the power of the transformation of the proximities; defaults to 1}

\item{nu}{the power of the transformation for weightmat; defaults to 1}

\item{weightmat}{a matrix of finite weights}

\item{init}{starting configuration}

\item{ndim}{dimension of the configuration; defaults to 2}

\item{acc}{numeric accuracy of the iteration}

\item{itmax}{maximum number of iterations. Defaults to 50000.}

\item{verbose}{should iteration output be printed; if > 1 then yes}
}
\value{
an object of class 'smacofP' (inheriting form 'smacofB', see \code{\link{smacofSym}}). It is a list with the components
\itemize{
\item delta: Observed dissimilarities, not normalized
\item obsdiss: Observed transformed dissimilarities, not normalized
\item confdist: Configuration dissimilarities, NOT normalized 
\item conf: Matrix of fitted configuration, NOT normalized
\item stress: Default stress  (stress 1; sqrt of explicitly normalized stress)
\item spp: Stress per point (based on stress.en) 
\item ndim: Number of dimensions
\item model: Name of smacof model
\item niter: Number of iterations
\item nobj: Number of objects
\item type: Type of MDS model
\item weightmat: weighting matrix
\item pars: hyperparameter vector theta
}
and some additional components
\itemize{
\item stress.m: default stress is the explicitly normalized stress on the normalized, transformed dissimilarities
\item deltaorig: observed, untransformed dissimilarities
\item kappa: kappa parameter
\item lambda: lambda parameter
\item nu: nu parameter (aka rho)
}
}
\description{
An implementation to minimize power stress by minimization-majorization. Usually more accurate but slower than powerStressFast.
}
\section{Note}{

The functionality related to power stress and the 'smacofP' class is also available in the 'cops' package. Expect masking when both are loaded.
}

\examples{
dis<-smacof::kinshipdelta
res<-powerStressMin(as.matrix(dis),kappa=2,lambda=1.5,nu=2,
                    weightmat=as.matrix(dis/2),itmax=1000)
res
summary(res)
plot(res)

}
\seealso{
\code{\link{smacofSym}}
}
\author{
Jan de Leeuw & Thomas Rusch
}
