% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_projected.R
\name{geo_select_aeq}
\alias{geo_select_aeq}
\title{Select a custom projected CRS for the area of interest}
\usage{
geo_select_aeq(shp)
}
\arguments{
\item{shp}{A spatial object with a geographic (WGS84) coordinate system}
}
\description{
This function takes a spatial object with a geographic (WGS84)
CRS and returns a custom projected CRS focussed on the centroid of the object.
This function is especially useful for using units of metres in all directions
for data collected anywhere in the world.
}
\details{
The function is based on this stackexchange answer:
\url{https://gis.stackexchange.com/questions/121489}
}
\examples{
sp::bbox(routes_fast)
new_crs <- geo_select_aeq(routes_fast)
rf_projected <- sp::spTransform(routes_fast, new_crs)
sp::bbox(rf_projected)
line_length <- rgeos::gLength(rf_projected, byid = TRUE)
plot(line_length, rf_projected$length)
shp <- zones_sf
geo_select_aeq(shp)
}
