% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route_bikecitizens.R
\name{route_bikecitizens}
\alias{route_bikecitizens}
\title{Get a route from the BikeCitizens web service}
\usage{
route_bikecitizens(
  from = NULL,
  to = NULL,
  base_url = "https://map.bikecitizens.net/api/v1/locations/route.json",
  cccode = "gb-leeds",
  routing_profile = "balanced",
  bike_profile = "citybike",
  from_lat = 53.8265,
  from_lon = -1.576195,
  to_lat = 53.80025,
  to_lon = -1.51577
)
}
\arguments{
\item{from}{A numeric vector representing the start point}

\item{to}{A numeric vector representing the end point}

\item{base_url}{The base URL for the routes}

\item{cccode}{The city code for the routes}

\item{routing_profile}{What type of routing to use?}

\item{bike_profile}{What type of bike?}

\item{from_lat}{Latitude of origin}

\item{from_lon}{Longitude of origin}

\item{to_lat}{Latitude of destination}

\item{to_lon}{Longitude of destination}
}
\description{
See \href{https://map.bikecitizens.net/gb-leeds#/!/1/1/53.8265,-1.576195/53.80025,-1.51577}{bikecitizens.net}
for an interactive version of the routing engine used by BikeCitizens.
}
\examples{
\donttest{
route_bikecitizens()
ldf <- od_coords(stplanr::od_data_lines[2, ])
r <- route_bikecitizens(ldf)
plot(r)
}
}
