% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtp.R
\name{gtp}
\alias{gtp}
\title{Global temporal pattern (GTP)}
\usage{
gtp(start_date, trend = "stable",
slope = NULL, first_pDate = NULL, show.plot =FALSE)
}
\arguments{
\item{start_date}{the start date of the temporal pattern.
The date should be in the format \code{"yyyy-mm-dd"}.
The GTP will normally cover a 1-year period.}

\item{trend}{specifies the direction of the
long-term trend. Options are:
\code{"falling"}, \code{"stable"},
and \code{"rising"}. Default value is: \code{"stable"}.}

\item{slope}{slope of the long-term trend when
an \code{"rising"} or \code{"falling"} trend is specified.
Options: \code{"gentle"} or \code{"steep"}. The default value is
set as \code{NULL} for the \code{stable} trend.}

\item{first_pDate}{date of the first seasonal peak of
the GTP (format: \code{"yyyy-mm-dd"}).
Default value is \code{NULL}, in which first seasonal
peak of 90 days is utilized.
seasonal cycle of 180 days is utilized (that is,
a seasonal cycle of 180 days).}

\item{show.plot}{(logical) Shows GTP.
Default is \code{FALSE}.}
}
\value{
Returns a time series (list) of 365
data points representing
1-year global temporal pattern.
}
\description{
Models the global temporal pattern,
as combining the long-term trend and seasonality.
}
\details{
Models the GTP for anchoring the temporal
trends and patterns of the point patterns to be simulated.
}
\examples{
gtp(start_date = "2020-01-01", trend = "stable",
slope = NULL, first_pDate = "2020-02-28", show.plot = FALSE)
}
