% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{grab}
\alias{grab}
\title{\code{grab} extracts the contents of objects in an environment based on their
object names as a character vector. The object contents are stored to a list
where the names are the object names.}
\usage{
grab(x, envir = sys.frame())
}
\arguments{
\item{x}{character vector providing the exact names of objects in the environment
\code{envir}.}

\item{envir}{environment to pull the objects from. Default is the global environment.}
}
\value{
list of objects with names \code{x}.
}
\description{
\code{grab} extracts the contents of objects in an environment based on their
object names as a character vector. The object contents are stored to a list
where the names are the object names.
}
\examples{
grab(x = c("attitude","mtcars","airquality"))
grab(x = c("mean.default","mean.Date","mean.difftime"))
}
