% Generated by roxygen2 (4.0.2): do not edit by hand
\name{as.dna.seq}
\alias{as.dna.seq}
\alias{is.aligned.seq}
\alias{is.dna.seq}
\alias{stopifnot.aligned}
\title{Format List of DNA Sequences}
\usage{
as.dna.seq(x)

is.aligned.seq(x, show.warnings = FALSE)

is.dna.seq(x, show.warnings = FALSE)

stopifnot.aligned(x, show.warnings = TRUE)
}
\arguments{
\item{x}{an R object of either matrix, data.frame, character vector, list, or DNAbin.}

\item{show.warnings}{logical - show warnings for is.dna.seq describing check failures?}
}
\description{
Format and test DNA sequences stored in lists.
}
\details{
\tabular{ll}{
  \code{as.dna.seq} \tab converts a \code{matrix}, \code{data.frame}, \code{vector},
    or \code{\link[ape]{DNAbin}} object to a list of character vectors. Nucleotides are
    stored as lower-case.\cr
  \code{is.aligned.seq} \tab tests if object is an aligned set of DNA sequences.
    Each sequence must be the same length.\cr
  \code{is.dna.seq} \tab tests if object is a list where each element is a character
    vector and every element in each vector is a valid IUPAC nucleotide code.\cr
  \code{stopifnot.aligned} \tab stops execution if object is not an aligned set of DNA sequences.\cr
}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

