% Generated by roxygen2 (4.0.2): do not edit by hand
\name{stat.phist}
\alias{stat.phist}
\title{PHIst Analysis of Population Structure}
\usage{
stat.phist(g, hap.dist = NULL, pairwise.deletion = TRUE, ...)
}
\arguments{
\item{g}{a \code{gtypes} object.}

\item{hap.dist}{a matrix of pairwise haplotype distances.}

\item{pairwise.deletion}{passed to \code{\link[ape]{dist.dna}}.}

\item{...}{other arguments passed to \code{\link[ape]{dist.dna}} such as
  \code{model}.}
}
\description{
PHIst Analysis of Population Structure
}
\examples{
data(dolph.strata)
data(dolph.haps)
mtdna <- gtypes(dolph.strata, id.col = 1, strata.col = 2, locus.col = 4, dna.seq = dolph.haps)

stat.phist(mtdna)
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\references{
Excoffier, L., Smouse, P.E., and J.M. Quattro. 1992. Analysis of molecular variance inferred from
  metric distances among DNA haplotypes: Application to human mitochondrial DNA restriction data
}

