% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freq2GenData.R
\name{freq2GenData}
\alias{freq2GenData}
\title{Convert Haplotype Frequency Matrices}
\usage{
freq2GenData(freq.mat, hap.col, freq.col, id.label = NULL, hap.label = NULL)
}
\arguments{
\item{freq.mat}{a matrix or data.frame containing haplotypic 
frequencies with strata as column names.}

\item{hap.col}{a number giving the column providing haplotype 
labels or a vector the same length as freq.mat.}

\item{freq.col}{a number giving the first column containing 
haplotype frequencies.}

\item{id.label}{character to label sample IDs with in resulting 
data.frame.}

\item{hap.label}{character to label haplotypes with in 
resulting data.frame.}
}
\value{
a data.frame with one row per sample and columns for id, strata, 
  and haplotype.
}
\description{
Create a data.frame of stratified individuals and their 
  haplotypes from a frequency table
}
\examples{
hap.freqs <- data.frame(
  haps = c("hap1", "hap2", "hap3"),
  pop1 = rmultinom(1, 50, prob = c(0.1, 0.2, 0.7)),
  pop2 = rmultinom(1, 25, prob = c(0.5, 0.4, 0.1))
)

gen.data <- freq2GenData(hap.freqs, hap.col = 1, freq.col = 2)

x <- df2gtypes(gen.data, ploidy = 1)
summary(x)

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

