% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arlequin.R
\name{arlequin}
\alias{arlequin}
\alias{read.arlequin}
\alias{write.arlequin}
\title{Read and Write Arlequin Files}
\usage{
read.arlequin(file)

write.arlequin(g, label = NULL, locus = 1)
}
\arguments{
\item{file}{filename of an input arlequin project (.arp) file.
\code{read.arlequin} can only read files with DataType of FREQUENCY, DNA, 
or MICROSAT.}

\item{g}{a \linkS4class{gtypes} object.}

\item{label}{label for Arlequin project filename (.arp). If \code{NULL}, the 
gtypes description is used if present.}

\item{locus}{numeric or character designation of which locus to write for 
haploid data.}
}
\description{
Read an Arlequin-formatted project input file into a 
  \code{gtypes} object, or write an input file from a \code{gtypes} object.
}
\references{
Excoffier, L.G. Laval, and S. Schneider (2005) 
  Arlequin ver. 3.0: An integrated software package for population genetics 
  data analysis. Evolutionary Bioinformatics Online 1:47-50.\cr
  Available at \url{http://cmpg.unibe.ch/software/arlequin3/}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
