% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opt.R
\name{nopt}
\alias{nopt}
\title{Minimum Sample Size Allocation in Stratified Sampling Schemes}
\usage{
nopt(D, a, b, M = NULL)
}
\arguments{
\item{D}{(\code{number})\cr variance equality constraint value. A strictly
positive scalar.}

\item{a}{(\code{numeric})\cr parameters \eqn{a_1, ..., a_H} of variance function
\eqn{D}. Strictly positive numbers.}

\item{b}{(\code{number})\cr parameter \eqn{b} of variance function \eqn{D}.}

\item{M}{(\code{numeric} or \code{NULL})\cr upper bounds constraints optionally imposed
on strata sample sizes. If different than \code{NULL}, it is then required that
\verb{D >= sum(a/M) - b > 0}. Strictly positive numbers.}
}
\value{
Numeric vector with optimal sample allocation in strata.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

User function that determines fixed strata sample sizes that minimize
total sample size, under assumed level of the variance of the stratified
pi-estimator of the total and optional one-sided upper bounds imposed on
strata sample sizes.
The algorithm used by \code{nopt()} is described in Wójciak (2022).
The allocation computed is valid for all stratified sampling schemes
for which the variance of the stratified pi-estimator is of the form
\deqn{D(x_1,...,x_H) = a^2_1/x_1 + ... + a^2_H/x_H - b,}
where \eqn{H} denotes total number of strata, \eqn{x_1, ..., x_H} are the
strata sample sizes, and \eqn{b}, \eqn{a_w > 0} do not depend on
\eqn{x_w, w = 1, ..., H}. \cr
}
\details{
The \code{nopt()} function computes
\deqn{argmin n(x_1,...,x_H) = x_1 + ... + x_H,}
under the equality constraint imposed on the variance
\deqn{a^2_1/x_1 + ... + a^2_H/x_H - b = D.}
Optionally, the following set of one-sided inequality constraints
can be added
\deqn{x_w <= M_w, w = 1,...,H,}
where \eqn{D > 0} is a given number and \eqn{M_w > 0, w = 1, ..., H}, are
the upper bounds, imposed on sample strata sizes.\cr
}
\note{
For simple random sampling without replacement design in each stratum,
parameters of the variance function \eqn{D} are
\eqn{b = N_1 * S_1^2 + ... + N_H * S_H^2}, and \eqn{a_w = N_w * S_w}, where
\eqn{N_w, S_w, w = 1, ..., H}, are strata sizes and standard deviations of
a study variable in strata respectively.
}
\examples{
a <- c(3000, 4000, 5000, 2000)
M <- c(100, 90, 70, 80)
nopt(1017579, a = a, b = 579, M = M)
}
\references{
Wójciak, W. (2022),
Minimum sample size allocation in stratified sampling under constraints on
variance and strata sample sizes,
\doi{10.48550/arXiv.2204.04035}
}
\seealso{
\code{\link[=rna_one_sided]{rna_one_sided()}}, \code{\link[=dopt]{dopt()}}.
}
