% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSD_Mixture.R
\name{DSD_Mixture}
\alias{DSD_Mixture}
\title{Mixes Data Points from Several Streams into a Single Stream}
\usage{
DSD_Mixture(..., prob = NULL)
}
\arguments{
\item{...}{\link{DSD} objects.}

\item{prob}{a numeric vector with the probability for each stream that the next point will
be drawn from that stream.}
}
\value{
Returns a \code{DSD_Mixture} object.(subclass of \link{DSD_R}, \link{DSD}).
}
\description{
This generator mixes multiple streams given specified probabilities.
The streams have to contain the same number of dimensions.
}
\examples{
# create data stream with three clusters in 2D
stream1 <- DSD_Gaussians(d = 2, k = 3)
stream2 <- DSD_UniformNoise(d = 2,  range = rbind(c(-.5, 1.5), c(-.5, 1.5)))

combinedStream <- DSD_Mixture(stream1, stream2, prob = c(.9, .1))
combinedStream

get_points(combinedStream, n = 20)
plot(combinedStream, n = 200)
}
\seealso{
Other DSD: 
\code{\link{DSD_BarsAndGaussians}()},
\code{\link{DSD_Benchmark}()},
\code{\link{DSD_Cubes}()},
\code{\link{DSD_Gaussians}()},
\code{\link{DSD_MG}()},
\code{\link{DSD_Memory}()},
\code{\link{DSD_NULL}()},
\code{\link{DSD_ReadDB}()},
\code{\link{DSD_ReadStream}()},
\code{\link{DSD_Target}()},
\code{\link{DSD_UniformNoise}()},
\code{\link{DSD_mlbenchData}()},
\code{\link{DSD_mlbenchGenerator}()},
\code{\link{DSD}()},
\code{\link{DSF}()},
\code{\link{animate_data}()},
\code{\link{close_stream}()},
\code{\link{get_points}()},
\code{\link{plot.DSD}()},
\code{\link{reset_stream}()}
}
\author{
Michael Hahsler
}
\concept{DSD}
