% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSC_WebService.R
\name{DSC_WebService}
\alias{DSC_WebService}
\title{A DSC Interface for a DSC Running as a Web Service}
\usage{
DSC_WebService(url, quiet = TRUE)
}
\arguments{
\item{url}{endpoint URI address in the format \verb{http://host:port/<optional_path>}.}

\item{quiet}{logical; if \code{FALSE} then connection attempts messages will be displayed.}
}
\value{
A \link[stream:DSC]{stream::DSC} object.
}
\description{
Provides a DSC front-end for a clusterer running as a web service. The methods
\code{nclusters()}, \code{get_center()}, \code{get_weights()} are supported.
}
\examples{
# find a free port
port <- httpuv::randomPort()
port

# deploy a clustering process listening for data on the port
rp1 <- publish_DSC_via_WebService("DSC_DBSTREAM(r = .05)", port = port)
rp1

# get a local DSC interface
dsc <- DSC_WebService(paste0("http://localhost:", port), quiet = FALSE)
dsc

# cluster
dsd <- DSD_Gaussians(k = 3, d = 2, noise = 0.05)

update(dsc, dsd, 500)

get_centers(dsc)
get_weights(dsc)

plot(dsc)

# kill the background clustering process.
rp1$kill()
rp1

}
\seealso{
Other WebService: 
\code{\link{DSD_ReadWebService}()},
\code{\link{publish_DSC_via_WebService}()},
\code{\link{publish_DSD_via_WebService}()}

Other dsc: 
\code{\link{publish_DSC_via_WebService}()}
}
\concept{WebService}
\concept{dsc}
