% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glover.R
\name{glover}
\alias{glover}
\title{Streamflow depletion with fully-penetrating stream and no streambed.}
\usage{
glover(t, d, S, Tr)
}
\arguments{
\item{t}{times you want output for [T]}

\item{d}{distance from well to stream [L]}

\item{S}{aquifer storage coefficient (specific yield if unconfined; storativity if confined)}

\item{Tr}{aquifer transmissivity [L2/T]}
}
\value{
A numeric of \code{Qf}, streamflow depletion as fraction of pumping rate [-].
If the pumping rate of the well (\code{Qw}; [L3/T]) is known, you can calculate volumetric streamflow depletion [L3/T] as \code{Qf*Qw}
}
\description{
Streamflow depletion with fully-penetrating stream and no streambed.
}
\details{
This function is described in Glover & Balmer (1954) based on work by Theis (1941). It contains numerous assumptions:
\itemize{
  \item Horizontal flow >> vertical flow (Dupuit assumptions hold)
  \item Homogeneous, isotropic aquifer
  \item Constant \code{Tr}: Aquifer is confined, or if unconfined change in head is small relative to aquifer thickness
  \item Stream is straight, infinitely long, and remains in hydraulic connection to aquifer
  \item Constant stream stage
  \item No changes in recharge due to pumping
  \item No streambank storage
  \item Constant pumping rate
  \item Aquifer extends to infinity
  \item Stream fully penetrates through aquifer (see \link{hunt} or \link{hantush} for partially penetrating stream)
  \item No streambed resistance to flow (see \link{hunt} or \link{hantush} for streambed resistance)
}
}
\examples{
glover(t = 1.5777e8, d = 1000, S = 0.2, Tr = 0.1)   # Glover & Balmer (1954) Table 1, Well 1
glover(t = 1.5777e8, d = 5000, S = 0.2, Tr = 0.1)   # Glover & Balmer (1954) Table 1, Well 2
glover(t = 1.5777e8, d = 10000, S = 0.2, Tr = 0.1)  # Glover & Balmer (1954) Table 1, Well 3
}
\references{
Glover, RE, and GG Balmer (1954).River Depletion Resulting from Pumping a Well near a River.
Eos, Transactions American Geophysical Union 35(3): 468-70. doi:10.1029/TR035i003p00468.

Theis, CV (1941). The Effect of a Well on the Flow of a Nearby Stream.
Eos, Transactions American Geophysical Union 22(3): 734-38. https://doi.org/10.1029/TR022i003p00734.
}
